org 100h
BASECOLOR equ 11
SCREENOFFSET equ 0x800

  mov al,12h    ; mode 640x480x16
  int 10h
  push 0A000h
  pop es
  fninit
  fldz          ;| t

M:mov dx,3CEh   ; GC index
  mov ax,BASECOLOR<<8  ; al=0 (GC set/reset), ah=color
  out dx,ax
  mov ax,0x0305 ; al=5 (GC mode), ah=read mode 0, write mode 3
  out dx,ax

  mov dl,0xDA   ; wait for retrace
W:in al,dx
  and al,8
  jz W

  xor di,di     ; copy buffer to screen, clear buffer
  mov ch,(640*480/8)>>8
C:salc
  xchg al,[di+SCREENOFFSET]
  stosb
  loop C

  mov dx,6

T:mov cl,dl
  add cl,cl
U:mov bp,dx

V:call S   ; generate point(cx,bp) on sphere, store to (bx,di)
  mov si,di
  xchg ax,bx ; (ax,si)

  inc bp
  call S
  call L   ; draw line from (bx>>6,di>>6) to (ax>>6,si>>6)
  dec bp

  inc cx
  call S
  call L
  dec cx

  dec bp
  jnz V

  loop U
  
  dec dx
  cmp dx,1
  jne T

  fiadd word[TT]; 44

  in al,60h
  cmp al,1
  jnz M
; ret

; generate point(cx,bp) on sphere, store to bx di

             ;     bx+14 12 10  8  6  4  2  0
S:pusha      ; pusha: ax cx dx bx sp bp si di
  mov bx,sp

  fiadd word[bx+10]               ; t += saved dx

  fild word[bx+12]; a t           ; saved cx
  fldpi
  fidiv word[bx+10]               ; saved dx
  fmulp

  fsincos         ; ca sa t
  fld st0         ; ca ca sa t
  fild word[bx+4] ; B ca ca sa t  ; saved bp
  fldpi
  fidiv word[bx+10]               ; saved dx
  fmulp
  
  fadd st4        ; b=B+t/Q ca ca sa t
  fsincos         ; cb sb ca ca sa t
  fmulp st2,st0   ; sb ca*cb ca sa t
  fmulp st2,st0   ; z=ca*cb y=ca*sb x=sa t
  
  fild word[bx+10]               ; saved dx
  fmul st3,st0
  fmul st2,st0
  fmulp st1,st0   ; Q*z Q*y Q*x t

  fld st0         ; z z y x t
  fld st3         ; x z z y x t
  fld st5
  fcos
  fsub st6      ; cos(t)-t x z z y x t
  fsincos       ; c s x z z y x t
  fmul st2,st0  ; c s cx z z y x t
  fmulp st3,st0 ; s cx cz z y x t
  fmul st3,st0  ; s cx cz sz y x t
  fmulp st5,st0 ; cx cz sz y sx t
  faddp st2,st0 ; cz cx+sz y sx t
  fsubp st3,st0 ; cx+sz y -sx+cz t

  fiadd word[DEPTH]  ; Z=z+D y x t
  fidivr word[ZOOM]  ; zoom/Z y x t
  fmul  st1,st0
  fmulp st2,st0    ; y/Z*zoom x/Z*zoom t
  fistp word[bx+8] ; saved bx
  fistp word[bx]   ; saved di

  fisub word[bx+10]               ; t -= saved dx
  popa
  ret

; draw line from (ax>>6,si>>6) to (bx>>6,di>>6)
L:pusha

; 63 constant steps
  sub di,si  ;dy
  sub bx,ax  ;dx
  mov cx,0x3F06 ; iters
  sar bx,cl
  sar di,cl

X:pusha  ; ax=x si=y bx=Dx di=Dy (i10.6)
  sar si,cl
  sar ax,cl
  imul si,80    ; offset = y*(w/8) + x/8
  xor al,7      ; bit = x xor 7
  bts [si+SCREENOFFSET+(240*640 + 320)/8],ax
F:popa
  add ax,bx ; advance (H)
  add si,di
N:dec ch
  jnz X
  popa
  ret

ZOOM  dw 20000
DEPTH dw 10
TT dw 44
